#ifndef CProjectil_H
#define CProjectil_H

#include "Cbob.h"
#include "Collide.h"
#include "CPartEmmit.h"

//Hrite des collides en mouvements
class CProjectil : public CCollideMv
{
    protected:
        float life;
        CbobOBJ bobObj;
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        void render();
        
    public:
        CProjectil(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        virtual ~CProjectil();
};

//Hrite des projectils
class CMissile : public CProjectil
{
    protected:
        unsigned char dmgExp;
        
        CPartEmmitDisp mD;
        CPartEmmit mt;
        
    protected:
        void boom();
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        
    public:
        CMissile(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        virtual ~CMissile();
};

//Missile  tte chercheuse
class CMissileEn : public CMissile
{
    private:
        float maj;
        
    protected:
        virtual bool frameMove(float elapsedTime);
        
    public:
        CMissileEn(unsigned char mdl,float life,unsigned char dmg,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        virtual ~CMissileEn();  
};

#endif
